#ifdef SKINNING

	uniform mat4 	boneMatrices[100];
	attribute vec4  weights;
	attribute vec4  matrixIndices;

#endif

#ifdef PSYSTEM

	uniform	vec4 	pparams[100]; 	

	vec4			tpos;
	uniform vec4	data;

	attribute vec4	index;
	varying float 	life;
#else
	#ifdef CUBEREFL

		varying vec3	w0,
						w1,
						w2;
		attribute vec3 	normal,
						tangent,
						binormal; 
		varying vec3	viewDir;
		uniform mat4	WTM;
		uniform vec3	campos;


	#endif

#endif

varying vec2 	texcoord;
uniform vec2	tscale0;

#ifdef BUMP2

	uniform vec2	tscale1;
	varying vec2 	texcoord1;
	uniform vec2	tofs1;

#endif

varying vec4 	pos;
uniform vec2	tofs;		// cambiare in uniform
uniform vec2	NF;
varying vec4	eyepos;
		
vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

void main()
{  
#ifdef SKINNING

	vec4 index  		= matrixIndices;
	vec4 weight 		= weights;
	vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
	
	mat4 TM;

  	for( int i = 0; i < 4; i++ )
 	{
 	    	// Apply influence of bone i
		TM=boneMatrices[int(index[i])];
  	    	position = position + (TM * gl_Vertex) *weight[i];
	}
	gl_Position = gl_ModelViewProjectionMatrix * position;
	eyepos = gl_ModelViewMatrix * position;
	
#else

	#ifdef PSYSTEM

		vec4 ppos=pparams[index.x];
		life=ppos.w;
		float scale=data.x + (data.y*(1.0-life));
		scale=clamp(scale,0.0,abs(scale))*0.5;
		scale+=scale*index.y;	
		ppos.w=1.0;

		float angle=(index.y*6.28)+(data.z*(1.0-life)*6.28);

		float cosa=cos(angle);
		float sina=sin(angle);

		tpos=gl_ModelViewMatrix * ppos;	

		vec3 tv=gl_Vertex;
		tv.x=(gl_Vertex.x*cosa)-(gl_Vertex.y*sina);
		tv.y=(gl_Vertex.x*sina)+(gl_Vertex.y*cosa);
		tpos.xyz=(tv.xyz*scale + tpos.xyz);

		eyepos=tpos;
		gl_Position=gl_ProjectionMatrix*tpos;
		
		//tofs=ComputeFrame(1.0-life, NF);
			
	#else
		#ifdef CUBEREFL
		
			vec4 normal4   	= vec4( normal.xyz, 0.0 );
			vec4 binormal4  = vec4( binormal.xyz, 0.0 );
			vec4 tangent4 	= vec4( tangent.xyz, 0.0 );

			vec4 	outTangent,
					outNormal,
					outBinormal;
			
			outNormal=normalize(WTM*normal4);
			outTangent=normalize(WTM*tangent4);
			outBinormal=normalize(WTM*binormal4);

			w0=vec3(outTangent.x,outBinormal.x,outNormal.x);
			w1=vec3(outTangent.y,outBinormal.y,outNormal.y);
			w2=vec3(outTangent.z,outBinormal.z,outNormal.z);

			// transform to world space
			vec4 vpos=WTM*gl_Vertex;

			// compute view direction
			viewDir=campos-vpos.xyz;

		#endif

		gl_Position = ftransform();
		eyepos = gl_ModelViewMatrix * gl_Vertex;
		
	#endif

#endif

	texcoord = gl_MultiTexCoord0.st*tscale0 + tofs;

#ifdef BUMP2

	texcoord1 = gl_MultiTexCoord0.st*tscale1 + tofs1;

#endif
	pos=gl_Position;

}